/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.media;

import android.os.Bundle;
import android.text.TextUtils;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.media.BaseMediaObject;
import com.umeng.socialize.media.SimpleShareContent;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.media.UMVideo;
import com.umeng.socialize.media.UMusic;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.utils.UmengText;

public class QQShareContent
extends SimpleShareContent {
    public int mShareType = 1;
    private String mediaTitle = "";
    private String mediades = "";

    public QQShareContent(ShareContent shareContent) {
        super(shareContent);
        if (shareContent.mMedia != null && shareContent.mMedia instanceof UMusic) {
            this.setMusic((UMusic)shareContent.mMedia);
        }
        if (shareContent.mMedia != null && shareContent.mMedia instanceof UMVideo) {
            this.setVideo((UMVideo)shareContent.mMedia);
        }
    }

    public Bundle buildParams(boolean isHideQzone, String appName) {
        Bundle mParams = new Bundle();
        if (this.getmStyle() == 2 || this.getmStyle() == 3) {
            this.mShareType = 5;
            this.buildImageParams(mParams);
        } else if (this.getmStyle() == 4) {
            if (this.getMusic() != null) {
                this.mShareType = 2;
            }
            this.buildAudioParams(mParams);
        } else if (this.getmStyle() == 16) {
            this.buildWebParams(mParams);
        } else if (this.getmStyle() == 8) {
            this.buildVideoParams(mParams);
        } else {
            mParams.putString("error", UmengText.supportStyle((boolean)false, (String)"text"));
        }
        mParams.putInt("req_type", this.mShareType);
        if (isHideQzone) {
            mParams.putInt("cflag", 2);
        } else {
            mParams.putInt("cflag", 1);
        }
        if (!TextUtils.isEmpty((CharSequence)appName)) {
            mParams.putString("appName", appName);
        }
        return mParams;
    }

    private void buildImageParams(Bundle bundle) {
        if (this.getImage() != null) {
            if (this.getImage().asFileImage() != null) {
                try {
                    bundle.putString("imageLocalUrl", this.getImage().asFileImage().toString());
                }
                catch (Exception e) {
                    bundle.putString("error", UmengText.QQ_PERMISSION);
                }
            } else {
                bundle.putString("error", UmengText.QQ_PERMISSION);
            }
        }
    }

    private void buildText(Bundle bundle) {
        bundle.putString("summary", this.getText());
    }

    private void buildVideoParams(Bundle bundle) {
        bundle.putString("title", this.objectSetTitle((BaseMediaObject)this.getVideo()));
        bundle.putString("summary", this.objectSetDescription((BaseMediaObject)this.getVideo()));
        UMImage thumb = this.getVideo().getThumbImage();
        if (thumb != null) {
            if (thumb.isUrlMedia()) {
                bundle.putString("imageUrl", thumb.toUrl());
            } else if (thumb != null && thumb.asFileImage() != null) {
                bundle.putString("imageLocalUrl", thumb.asFileImage().toString());
            } else {
                bundle.putString("error", UmengText.QQ_PERMISSION);
            }
        }
        bundle.putString("targetUrl", this.getVideo().toUrl());
    }

    private void buildWebParams(Bundle bundle) {
        bundle.putString("title", this.objectSetTitle((BaseMediaObject)this.getUmWeb()));
        bundle.putString("summary", this.objectSetDescription((BaseMediaObject)this.getUmWeb()));
        UMImage thumb = this.getUmWeb().getThumbImage();
        if (thumb != null) {
            if (thumb.isUrlMedia()) {
                bundle.putString("imageUrl", thumb.toUrl());
            } else if (thumb != null && thumb.asFileImage() != null) {
                bundle.putString("imageLocalUrl", thumb.asFileImage().toString());
            } else {
                bundle.putString("error", UmengText.QQ_PERMISSION);
            }
        }
        if (TextUtils.isEmpty((CharSequence)this.getUmWeb().toUrl())) {
            bundle.putString("error", UmengText.EMPTY_WEB_URL);
        }
        bundle.putString("targetUrl", this.getUmWeb().toUrl());
    }

    private void buildAudioParams(Bundle bundle) {
        bundle.putString("title", this.objectSetTitle((BaseMediaObject)this.getMusic()));
        bundle.putString("summary", this.objectSetDescription((BaseMediaObject)this.getMusic()));
        UMImage thumb = this.getMusic().getThumbImage();
        if (thumb != null) {
            if (thumb.isUrlMedia()) {
                bundle.putString("imageUrl", thumb.toUrl());
            } else if (thumb != null && thumb.asFileImage() != null) {
                bundle.putString("imageLocalUrl", thumb.asFileImage().toString());
            } else {
                bundle.putString("error", UmengText.QQ_PERMISSION);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.getMusic().getmTargetUrl())) {
            bundle.putString("targetUrl", this.getMusic().getmTargetUrl());
        } else {
            bundle.putString("targetUrl", this.getMusic().toUrl());
            Log.um((String)UmengText.QQ_MUSIC);
        }
        bundle.putString("audio_url", this.getMusic().toUrl());
    }
}

