/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.share.sdk.openapi.channel;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.alipay.share.sdk.Constant;
import com.alipay.share.sdk.openapi.channel.MMessageUtil;

public class APMessageAct {
    private static final String TAG = "APSDK.APMessageAct";

    public static boolean send(Context context, String scheme, String content, Bundle bundle) {
        if (context != null && !TextUtils.isEmpty((CharSequence)scheme)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)scheme));
            if (bundle != null) {
                intent.putExtras(bundle);
            }
            String packageName = context.getPackageName();
            intent.putExtra(Constant.EXTRA_MESSAGE_SDK_VERSION, 20150630);
            intent.putExtra(Constant.EXTRA_MESSAGE_APP_PACKAGE_NAME, packageName);
            intent.putExtra(Constant.EXTRA_MESSAGE_CONTENT, content);
            intent.putExtra("actionType", "outShare");
            intent.putExtra(Constant.EXTRA_MESSAGE_CHECK_SUM, MMessageUtil.checkSum(content, packageName));
            if (Build.VERSION.SDK_INT > 23) {
                intent.addFlags(0x10000000).addFlags(0x8000000);
            } else {
                intent.addFlags(0x10000000);
            }
            try {
                context.startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                Log.e((String)TAG, (String)"send fail, target ActivityNotFound");
                return false;
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)("send fail " + exception.getMessage()));
                return false;
            }
            Log.d((String)TAG, (String)("send alipay message, intent=" + intent));
            return true;
        }
        Log.e((String)TAG, (String)"send fail, invalid arguments");
        return false;
    }

    public static boolean sendToZFB(Context context, String content, Bundle bundle) {
        return APMessageAct.send(context, "alipays://platformapi/startapp?appId=20000167&actionType=outShare", content, bundle);
    }
}

