/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.share.sdk.openapi;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.Log;
import com.alipay.share.sdk.Constant;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class APMediaMessage {
    private static final String TAG = "APSDK.ZFBMediaMessage";
    public int sdkVer;
    public String title;
    public String description;
    public byte[] thumbData;
    public String thumbUrl;
    public IMediaObject mediaObject;

    public APMediaMessage() {
        this(null);
    }

    public APMediaMessage(IMediaObject iMediaObject) {
        this.mediaObject = iMediaObject;
    }

    public final int getType() {
        return this.mediaObject == null ? 0 : this.mediaObject.type();
    }

    public final void setThumbImage(Bitmap bitmap) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)byteArrayOutputStream);
            this.thumbData = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"put thumb failed");
        }
    }

    final boolean checkArgs() {
        if (this.thumbData != null && this.thumbData.length > 32768) {
            Log.e((String)TAG, (String)"checkArgs fail, thumbData is invalid");
            return false;
        }
        if (this.title != null && this.title.length() > 512) {
            Log.e((String)TAG, (String)"checkArgs fail, title is invalid");
            return false;
        }
        if (this.description != null && this.description.length() > 1024) {
            Log.e((String)TAG, (String)"checkArgs fail, description is invalid");
            return false;
        }
        if (this.mediaObject == null) {
            Log.e((String)TAG, (String)"checkArgs fail, mediaObject is null");
            return false;
        }
        return this.mediaObject.checkArgs();
    }

    public static class Builder {
        public static Bundle toBundle(APMediaMessage apMediaMessage) {
            Bundle bundle = new Bundle();
            bundle.putInt(Constant.EXTRA_AP_OBJECT_SDK_VERSION, apMediaMessage.sdkVer);
            bundle.putString(Constant.EXTRA_AP_OBJECT_TITLE, apMediaMessage.title);
            bundle.putString(Constant.EXTRA_AP_OBJECT_DESCRIPTION, apMediaMessage.description);
            bundle.putByteArray(Constant.EXTRA_AP_OBJECT_THUMB_DATA, apMediaMessage.thumbData);
            bundle.putString(Constant.EXTRA_AP_OBJECT_THUMB_URL, apMediaMessage.thumbUrl);
            if (apMediaMessage.mediaObject != null) {
                bundle.putString(Constant.EXTRA_AP_OBJECT_IDENTIFIER, apMediaMessage.mediaObject.getClass().getSimpleName());
                apMediaMessage.mediaObject.serialize(bundle);
            }
            return bundle;
        }

        public static APMediaMessage fromBundle(Bundle bundle) {
            APMediaMessage apMediaMessage = new APMediaMessage();
            apMediaMessage.sdkVer = bundle.getInt(Constant.EXTRA_AP_OBJECT_SDK_VERSION);
            apMediaMessage.title = bundle.getString(Constant.EXTRA_AP_OBJECT_TITLE);
            apMediaMessage.description = bundle.getString(Constant.EXTRA_AP_OBJECT_DESCRIPTION);
            apMediaMessage.thumbData = bundle.getByteArray(Constant.EXTRA_AP_OBJECT_THUMB_DATA);
            apMediaMessage.thumbUrl = bundle.getString(Constant.EXTRA_AP_OBJECT_THUMB_URL);
            String className = bundle.getString(Constant.EXTRA_AP_OBJECT_IDENTIFIER);
            if (className != null && className.length() > 0) {
                try {
                    Class<?> clazz = Class.forName(className);
                    apMediaMessage.mediaObject = (IMediaObject)clazz.newInstance();
                    apMediaMessage.mediaObject.unserialize(bundle);
                    return apMediaMessage;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.e((String)APMediaMessage.TAG, (String)("get media object from bundle failed: unknown ident " + className));
                    return apMediaMessage;
                }
            }
            return apMediaMessage;
        }
    }

    public static interface IMediaObject {
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_TEXT = 11;
        public static final int TYPE_IMAGE = 14;
        public static final int TYPE_STOCK = 120;
        public static final int TYPE_URL = 1001;
        public static final int TYPE_TAOBAO_GOODS = 1010;
        public static final int TYPE_FUND = 122;

        public void serialize(Bundle var1);

        public void unserialize(Bundle var1);

        public int type();

        public boolean checkArgs();
    }
}

